(function( $ ) {
    'use strict';
    var VisualNetAnimation = {
        initNet: function () {
            elementorFrontend.hooks.addAction('frontend/element_ready/section', VisualNetAnimation.initNetWidget);
        },
        initNetWidget: function ($scope) {
            var sectionId = $scope.data('id');
            var target = '.elementor-element-' + sectionId;
            var settings = {};
            if (window.isEditMode || window.elementorFrontend.isEditMode()) {
                var editorElements = null;
                var netAnimationArgs = {};

                if (!window.elementor.hasOwnProperty('elements')) {
                    return false;
                }

                editorElements = window.elementor.elements;

                if (!editorElements.models) {
                    return false;
                }

                $.each(editorElements.models, function (i, el) {
                    if (sectionId === el.id) {
                        netAnimationArgs = el.attributes.settings.attributes;
                    } else if (el.id === $scope.closest('.elementor-top-section').data('id')) {
                        $.each(el.attributes.elements.models, function (i, col) {
                            $.each(col.attributes.elements.models, function (i, subSec) {
                                netAnimationArgs = subSec.attributes.settings.attributes;
                            });
                        });
                    }
                    settings.switch = netAnimationArgs.marvy_enable_net_animation;
                    settings.bgColor = netAnimationArgs.marvy_net_animation_background_color;
                    settings.color = netAnimationArgs.marvy_net_animation_color;
                    settings.points = netAnimationArgs.marvy_net_animation_points;
                    settings.maxDistance = netAnimationArgs.marvy_net_animation_max_distance;
                    settings.spacing = netAnimationArgs.marvy_net_animation_spacing;
                    settings.showDots = netAnimationArgs.marvy_net_animation_show_dots;
                });

            } else {
                settings.switch = $scope.data("marvy_enable_net_animation");
                settings.bgColor = $scope.data("marvy_net_animation_background_color");
                settings.color = $scope.data("marvy_net_animation_color");
                settings.points = $scope.data("marvy_net_animation_points");
                settings.maxDistance = $scope.data("marvy_net_animation_max_distance");
                settings.spacing = $scope.data("marvy_net_animation_spacing");
                settings.showDots = $scope.data("marvy_net_animation_show_dots");
            }

            if (settings.switch) {
                netAnimation(target, settings, sectionId);
            }
        }
    };

    function netAnimation(target,settings,sectionId) {
        var checkElement = document.getElementsByClassName("marvy-net-section-" + sectionId);
        if (checkElement.length >= 0) {

            var net_div = document.createElement('div');
            net_div.classList.add("marvy-net-section-" + sectionId);

            document.querySelector(target).appendChild(net_div);
            document.querySelector(target).classList.add("marvy-custom-net-animation-section-" + sectionId);

            // Set Z-index for section container
            var netZindex = document.querySelector('.marvy-custom-net-animation-section-'+sectionId+' .elementor-container');
            netZindex.style.zIndex = '99';

            // Set min height
            var netMinHeight = document.querySelector(".elementor-element-"+sectionId);
            netMinHeight.closest('.elementor-top-section').style.minHeight = "400px";

            VANTA.NET({
                el: ".marvy-net-section-" + sectionId,
                mouseControls: true,
                touchControls: true,
                gyroControls: false,
                minHeight: 400.00,
                scale: 1.00,
                scaleMobile: 1.00,
                backgroundColor: settings.bgColor,
                color: settings.color,
                points: settings.points,
                maxDistance: settings.maxDistance,
                spacing: settings.spacing,
                showDots: settings.showDots
            });

        }
        return true;
    }

    $( window ).on('elementor/frontend/init', VisualNetAnimation.initNet);
})( jQuery );